import pandas as pd   
import pickle

# Load the dataset
laptops_price = pd.read_csv("laptops_price.csv")

price_conversion_rate = 1e-4
 
# Remove 'kg' from the weight values and convert to float
laptops_price['Weight'] = laptops_price['Weight'].str.replace('kg', '')
laptops_price['Weight'] = pd.to_numeric(laptops_price['Weight'], errors='coerce')
 
# Drop rows with NaN values in the 'Weight' column
laptops_price = laptops_price.dropna(subset=['Weight'])
 
# Convert weight to pounds
laptops_price['Weight_pounds'] = laptops_price['Weight'] * 2.20462
 
# Apply the price conversion rate
laptops_price['Price'] = laptops_price['Price'] * price_conversion_rate
 
# Filter the dataset
filtered_laptops = laptops_price[
    (laptops_price['Weight_pounds'] <= 3) &
    (laptops_price['Screen Size'].str.replace('"', '').astype(float).between(13, 15)) &
    (laptops_price['Price'].between(800, 1500))
]
 
# Select the required columns (without 'Storage')
filtered_laptops = filtered_laptops[['Manufacturer', 'Model Name', 'Category', 'Screen Size', 'Screen', 'CPU', 'RAM', 'GPU', 'Operating System', 'Operating System Version', 'Weight', 'Price']]

print(filtered_laptops)
pickle.dump(filtered_laptops,open("./ref_result/filtered_laptops.pkl","wb"))
